/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.mobevent;

import com.lycanitesmobs.AssetManager;
import com.lycanitesmobs.ExtendedWorld;
import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.core.config.ConfigSpawning;
import com.lycanitesmobs.core.entity.EntityCreatureBase;
import com.lycanitesmobs.core.info.GroupInfo;
import com.lycanitesmobs.core.mobevent.MobEventClient;
import com.lycanitesmobs.core.mobevent.MobEventManager;
import com.lycanitesmobs.core.mobevent.MobEventServer;
import com.lycanitesmobs.core.spawning.SpawnTypeBase;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.EntityLiving;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;

public class MobEventBase {
    public static boolean canAffectWeather = true;
    public static boolean canAffectTime = true;
    public static boolean aggressiveEvents = false;
    public String name = "mobevent";
    public int weight = 8;
    public List<SpawnTypeBase> spawners = new ArrayList<SpawnTypeBase>();
    public GroupInfo group;
    public boolean forceSpawning = true;
    public boolean forceNoDespawn = true;
    public int minDay = 0;
    public int firstScheduleDay = -1;
    public int duration = 1200;
    public int mobDuration = 12000;
    public String dimensionEntries = "-1, 1";
    public int[] dimensionBlacklist;
    public String[] dimensionTypes;
    public boolean dimensionWhitelist = false;

    public static void loadGlobalSettings() {
        ConfigSpawning config = ConfigSpawning.getConfig(LycanitesMobs.group, "mobevents");
        canAffectWeather = config.getBool("Global Event Settings", "Affect Weather", canAffectWeather, "Set to false to prevent all events from changing the weather.");
        canAffectTime = config.getBool("Global Event Settings", "Affect Time", canAffectTime, "Set to false to prevent all events from changing the time fo day.");
        aggressiveEvents = config.getBool("Global Event Settings", "Aggressive Events", aggressiveEvents, "If set to true, all mobs spawned from events will be told to immediately target the player, they will lose their target if too far however (for performance).");
    }

    public MobEventBase(String name, GroupInfo group) {
        this.name = name;
        this.group = group;
        AssetManager.addSound("mobevent_" + this.name.toLowerCase(), this.group, "mobevent." + this.name.toLowerCase());
    }

    public void loadFromConfig() {
        ConfigSpawning config = ConfigSpawning.getConfig(LycanitesMobs.group, "mobevents");
        this.duration = config.getInt("Event Durations", this.name, this.duration);
        this.mobDuration = config.getInt("Event Mob Durations", this.name, this.mobDuration);
        this.forceSpawning = config.getBool("Event Forced Spawning", this.name, this.forceSpawning);
        this.forceNoDespawn = config.getBool("Event Forced No Despawning", this.name, this.forceNoDespawn);
        this.minDay = config.getInt("Event Day Minimums", this.name, this.minDay);
        ConfigSpawning.SpawnDimensionSet eventDimensions = config.getDimensions("Event Dimensions", this.name + " Dimensions", this.dimensionEntries);
        this.dimensionBlacklist = eventDimensions.dimensionIDs;
        this.dimensionTypes = eventDimensions.dimensionTypes;
        this.dimensionWhitelist = config.getBool("Event Dimensions", this.name + " Dimensions Whitelist Mode", this.dimensionWhitelist);
    }

    public String getTitle() {
        return I18n.func_74838_a((String)("mobevent." + this.name + ".name"));
    }

    public String getDisplayTitle() {
        String title = this.getTitle().replaceAll(" ", "").toLowerCase();
        return title.equalsIgnoreCase(this.name) ? "" : title;
    }

    public boolean isEnabled() {
        ConfigSpawning config = ConfigSpawning.getConfig(LycanitesMobs.group, "mobevents");
        return config.getBool("Events Enabled", this.name, true);
    }

    public boolean canStart(World world, ExtendedWorld worldExt) {
        if (world.field_73011_w == null || !this.hasSpawners()) {
            return false;
        }
        if (worldExt.mobEventsLocked && !worldExt.mobEventsLockedOnlyOnSchedule && this.firstScheduleDay < 0) {
            return false;
        }
        boolean validDimension = false;
        for (String eventDimensionType : this.dimensionTypes) {
            if ("ALL".equalsIgnoreCase(eventDimensionType)) {
                validDimension = true;
                continue;
            }
            if (!"VANILLA".equalsIgnoreCase(eventDimensionType)) continue;
            validDimension = world.field_73011_w.getDimension() > -2 && world.field_73011_w.getDimension() < 2;
        }
        if (!validDimension) {
            validDimension = !this.dimensionWhitelist;
            for (int eventDimension : this.dimensionBlacklist) {
                if (world.field_73011_w.getDimension() != eventDimension) continue;
                validDimension = this.dimensionWhitelist;
                break;
            }
        }
        int n = (int)Math.floor((double)(worldExt.useTotalWorldTime ? world.func_82737_E() : world.func_72820_D()) / 24000.0);
        int minimumRandomDay = this.minDay;
        if (worldExt.mobEventsLocked) {
            minimumRandomDay = Math.max(minimumRandomDay, this.firstScheduleDay);
        }
        return validDimension && n >= minimumRandomDay;
    }

    public MobEventBase setDimensions(String string) {
        this.dimensionEntries = string;
        return this;
    }

    public int getRate(World world) {
        int base = MobEventManager.instance.baseRate;
        if (world.func_175659_aa().func_151525_a() <= 1) {
            return Math.round((float)base * 1.5f);
        }
        if (world.func_175659_aa().func_151525_a() == 2) {
            return base;
        }
        return Math.round((float)base * 0.75f);
    }

    public int getRange(World world) {
        int base = MobEventManager.instance.baseRange;
        if (world.func_175659_aa().func_151525_a() <= 1) {
            return Math.round((float)base * 1.5f);
        }
        if (world.func_175659_aa().func_151525_a() == 2) {
            return base;
        }
        return Math.round((float)base * 0.75f);
    }

    public MobEventBase addSpawner(SpawnTypeBase spawner) {
        if (!this.spawners.contains(spawner) && spawner.hasSpawns()) {
            this.spawners.add(spawner);
            spawner.setMobEvent(this);
        }
        return this;
    }

    public boolean hasSpawners() {
        return this.spawners.size() > 0;
    }

    public void onStart(World world, int rank) {
    }

    public void onFinish(World world, int rank) {
    }

    public void onSpawn(EntityLiving entity, int rank) {
        if (entity instanceof EntityCreatureBase) {
            EntityCreatureBase entityCreature = (EntityCreatureBase)entity;
            entityCreature.setTemporary(this.mobDuration);
        }
    }

    public MobEventServer getServerEvent(World world) {
        return new MobEventServer(this, world);
    }

    public MobEventClient getClientEvent(World world) {
        return new MobEventClient(this, world);
    }
}

